﻿/*
 * Aufgrund der wenigen Daten eignet sich evt. ein ListDictionary.
 * Ein StringDictionary ist evt. günstig, da zumindest die Casts nach String
 * entfallen. 
 * Möchten Sie nicht selbst herausfinden, was am günstigsten ist, verwenden Sie
 * doch das HybridDictionary.
 */

using System;
using System.Collections;
using System.Collections.Specialized;

namespace CSharpBuch.Kap16
{
  class Aufgabe4
  {
    string[] monate = {"Januar", "Februar", "März", "April", "Mai", "Juni",
                       "Juli", "August", "September", "Oktober", "November", "Dezember"};
    int[] tage = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
    StringDictionary sd;

    static void Main(string[] args)
    {
      string eingabe;
      int anzTage;
      Aufgabe4 a4 = new Aufgabe4();
      a4.Init();

      do
      {
        Console.WriteLine("Geben Sie einen Monatsnamen ein:");
        eingabe = Console.ReadLine();

        anzTage = a4.Anfrage(eingabe);
        if (anzTage > 0)
          Console.WriteLine("Der Monat {0} hat {1} Tage.", eingabe, anzTage);
        else
          Console.WriteLine("Da haben Sie wohl einen ungültigen Monat eingegeben");

        Console.WriteLine("Noch einmal (Ja/Nein) ?");
        eingabe = Console.ReadLine().ToUpper();
      }
      while (eingabe == "JA");

      Console.ReadLine();
    }

    public int Anfrage(string monat)
    {
      if (sd.ContainsKey(monat))
        return Int32.Parse(sd[monat]);
      else
        return 0;
    }

    public void Init()
    {
      sd = new StringDictionary();
      for (int i = 0; i < monate.Length; i++)
        sd.Add(monate[i], tage[i].ToString());
    }
  }
}